//-----------------------------------------------------------------------------
// Microsoft OLE DB RowsetViewer
// Copyright (C) 1994 - 1998 By Microsoft Corporation.
//
// @doc
//
// @module CENUM.CPP
//
//-----------------------------------------------------------------------------------

/////////////////////////////////////////////////////////////////
// Includes
//
/////////////////////////////////////////////////////////////////
#include "Common.h"
#include "CEnum.h"
#include "CDialog.h"	//CListBox
#include "Main.h"
#include "msdaguid.h"	//CLSID_OLEDB_ENUMERATOR


/////////////////////////////////////////////////////////////////
// CEnum::CEnum
//
/////////////////////////////////////////////////////////////////
CEnum::CEnum(HWND hWnd, CMainWindow* pCMainWindow, CListBox* pCListBox)
{
	ASSERT(pCMainWindow);
	m_pCMainWindow = pCMainWindow;
	ASSERT(pCListBox);
	m_pCListBox = pCListBox;
	
	//Enumerator ProvierInfo
	m_cEnumInfo				= 0;	
	m_rgEnumInfo			= NULL;
	m_pIParseDisplayName	= NULL; //Enumerator
	m_hWnd					= NULL;
}

/////////////////////////////////////////////////////////////////
// CEnum::~CEnum
//
/////////////////////////////////////////////////////////////////
CEnum::~CEnum()
{
	//Enumerator ProviderInfo
	m_cEnumInfo			= 0;	
	SAFE_FREE(m_rgEnumInfo);
	SAFE_RELEASE(m_pIParseDisplayName);
}


/////////////////////////////////////////////////////////////////
// BOOL CEnum::GetEnumInfo
//
/////////////////////////////////////////////////////////////////
ENUMINFO* CEnum::GetEnumInfo()
{
	ASSERT(m_rgEnumInfo);
	return m_rgEnumInfo;
}


/////////////////////////////////////////////////////////////////
// BOOL CEnum::GetEnumInfo
//
/////////////////////////////////////////////////////////////////
ENUMINFO* CEnum::GetEnumInfo(ULONG iIndex)
{
	ASSERT(m_rgEnumInfo);
	ASSERT(iIndex < m_cEnumInfo);
	return &m_rgEnumInfo[iIndex];
}


/////////////////////////////////////////////////////////////////////////////
// HRESULT CEnum::CreateProvider
//
/////////////////////////////////////////////////////////////////////////////
HRESULT CEnum::CreateProvider(IParseDisplayName* pIParseDisplayName, WCHAR* pwszParseName, DWORD dwCLSCTX, REFIID riid, IUnknown** ppIUnknown, DWORD dwConnectOpts, WCHAR* pwszRemoteServer)
{
	ASSERT(pwszParseName);
	ASSERT(ppIUnknown);

	IMoniker* pIMoniker = NULL;
	IBindCtx* pIBindCtx = NULL;
	ULONG chEaten = 0;
	CLSID clsid;
	HRESULT hr = E_FAIL;

	//If the user passes in a ParseDisplayName object, use that,
	//Otherwise use the Root Enum ParseDisplayName object...
	if(pIParseDisplayName == NULL)
		pIParseDisplayName = m_pIParseDisplayName;

	//Try and use ParseDisplayName
	//Otherwise we may be forced to just try CoCreateInstance if not installed...
	//Also cannot use ParseDisplayName if trying to aggregate ServiceComponents
	if(pIParseDisplayName && !(dwConnectOpts & CONNECT_USESERVICECOMP))
	{
		if(dwCLSCTX)
		{
			//Setup BIND_OPTS
			BIND_OPTS2 BindOps2;
			BindOps2.cbStruct		= sizeof(BIND_OPTS2);
			BindOps2.grfFlags		= BIND_MAYBOTHERUSER;
			BindOps2.grfMode		= STGM_READWRITE;
			BindOps2.dwTickCountDeadline = 0;
			BindOps2.dwTrackFlags	= 1;
			BindOps2.dwClassContext = dwCLSCTX;
			BindOps2.locale			= GetSystemDefaultLCID();
			BindOps2.pServerInfo	= NULL; 
			
			//Setup ServerInfo just incase we need it...
			COSERVERINFO	ServerInfo	= { 0, pwszRemoteServer, NULL, 0};
			MULTI_QI		MultiQI		= { &riid, NULL, S_OK};

			//Setup RemoteServer is specified
			if(dwCLSCTX & CLSCTX_REMOTE_SERVER)
				BindOps2.pServerInfo = &ServerInfo;

			//If this fails for some reason, we can still continue...
			hr = CreateBindCtx(0, &pIBindCtx);
			if(SUCCEEDED(hr) && pIBindCtx)
				hr = pIBindCtx->SetBindOptions(&BindOps2);

			//If it does fail we will just release the Bind Context and pass
			//IParseDisplayName NULL and let it choose the CLXCTX...
			if(FAILED(hr))
				SAFE_RELEASE(pIBindCtx);
		}
		
		//ParseDisplayName
		//Don't display error, since we have our own retry logic...
		TESTC(m_pCListBox->OutputPreMethod("IParseDisplayName::ParseDisplayName(0x%08x, %S, &%d, &0x%08x)", pIBindCtx, pwszParseName, chEaten, pIMoniker));
		hr = pIParseDisplayName->ParseDisplayName(pIBindCtx, pwszParseName, &chEaten, &pIMoniker);
		m_pCListBox->OutputPostMethod(hr, "IParseDisplayName::ParseDisplayName(0x%08x, %S, &%d, &0x%08x)", pIBindCtx, pwszParseName, chEaten, pIMoniker);
		
		if(SUCCEEDED(hr))
		{
			TESTC(m_pCListBox->OutputPreMethod("BindMoniker(0x%08x, 0, %s, &0x%08x)", pIBindCtx, GetInterfaceName(riid), ppIUnknown ? *ppIUnknown : NULL));
			XTEST(m_hWnd, hr = BindMoniker(pIMoniker, 0, riid, (void**)ppIUnknown));
			TESTC(m_pCListBox->OutputPostMethod(hr, "BindMoniker(0x%08x, 0, %s, &0x%08x)", pIBindCtx, GetInterfaceName(riid), ppIUnknown ? *ppIUnknown : NULL));
		}
	}
	
	//If Not using RootEnum or for some reason the RootEnum failed, 
	if(pIParseDisplayName == NULL || FAILED(hr))
	{
		//Find the CLSID from the ParseName
		//The user may have entered a ProgID or a CLSID 
		//Since the ParseName is a CLSID, try the common cvase first...
		if(FAILED(hr = CLSIDFromString(pwszParseName, &clsid)))
			XTESTC(m_hWnd, hr = CLSIDFromProgID(pwszParseName, &clsid));
				
		//Delegate
		TESTC(hr = CreateProvider(NULL, clsid, dwCLSCTX, riid, (IUnknown**)ppIUnknown, dwConnectOpts, pwszRemoteServer));
	}
	
CLEANUP:
	m_pCListBox->OutputRelease((IUnknown**)&pIMoniker, "IMoniker");
	SAFE_RELEASE(pIBindCtx);
	return hr;
}


/////////////////////////////////////////////////////////////////////////////
// HRESULT CEnum::CreateProvider
//
/////////////////////////////////////////////////////////////////////////////
HRESULT CEnum::CreateProvider(IUnknown* pIUnkOuter, CLSID clsid, DWORD dwCLSCTX, REFIID riid, IUnknown** ppIUnknown, DWORD dwConnectOpts, WCHAR* pwszRemoteServer)
{
	ASSERT(ppIUnknown);
	HRESULT hr = S_OK;

	//CLSID to String (just for display purposes...)
	WCHAR* pwszProgID = GetProgID(clsid);
	IDataInitialize* pIDataInitialize = NULL;

	//If using Service Components
	if(dwConnectOpts & CONNECT_USESERVICECOMP)
	{
		//CoCreateInstance on the ServiceComponents
		//We do this again here, incase you want Remoted Providers...
		XTESTC(m_hWnd, hr = CreateInstance(NULL, CLSID_MSDAINITIALIZE, dwCLSCTX, IID_IDataInitialize, (IUnknown**)&pIDataInitialize, pwszRemoteServer));

		//The provider is always "inproc" to whereever the ServiceComponents are:
		dwCLSCTX = CLSCTX_INPROC_SERVER;

		//Now Obtain Instance of Aggregated Provider
		m_pCListBox->OutputPreMethod("IDataInitialize::CreateDBInstance(%S, 0x%08x, %d, \"pwszReserved\", %s, &0x%08x)", pwszProgID, pIUnkOuter, dwCLSCTX, GetInterfaceName(riid), ppIUnknown ? *ppIUnknown : NULL);
		XTEST(m_hWnd, hr = pIDataInitialize->CreateDBInstance(clsid, pIUnkOuter, dwCLSCTX, L"pwszReserved", riid, ppIUnknown));
		m_pCListBox->OutputPostMethod(hr, "IDataInitialize::CreateDBInstance(%S, 0x%08x, %d, \"pwszReserved\", %s, &0x%08x)", pwszProgID, pIUnkOuter, dwCLSCTX, GetInterfaceName(riid), ppIUnknown ? *ppIUnknown : NULL);
	}
	else
	{
		//Delegate
		TESTC(hr = CreateInstance(pIUnkOuter, clsid, dwCLSCTX, riid, ppIUnknown, pwszRemoteServer));
	}
	
CLEANUP:
	SAFE_RELEASE(pIDataInitialize);
	SAFE_FREE(pwszProgID);
	return hr;
}

WINOLEAPI CoCreateInstanceEx(REFCLSID, IUnknown*, DWORD, COSERVERINFO*, DWORD, MULTI_QI*);
/////////////////////////////////////////////////////////////////////////////
// HRESULT CEnum::CreateInstance
//
/////////////////////////////////////////////////////////////////////////////
HRESULT CEnum::CreateInstance(IUnknown* pIUnkOuter, CLSID clsid, DWORD dwCLSCTX, REFIID riid, IUnknown** ppIUnknown, WCHAR* pwszRemoteServer)
{
	ASSERT(ppIUnknown);
	HRESULT hr = S_OK;

	//CLSID to String (just for display purposes...)
	WCHAR* pwszProgID = GetProgID(clsid);

	//Determine which method to use...
	if(dwCLSCTX & CLSCTX_REMOTE_SERVER)
	{
		//Setup ServerInfo...
		COSERVERINFO	ServerInfo	= { 0, pwszRemoteServer, NULL, 0};
		MULTI_QI		MultiQI		= { &riid, NULL, S_OK};

		//CoCreateInstanceEx
		TESTC(m_pCListBox->OutputPreMethod("CoCreateInstanceEx(%S, 0x%08x, %d, &0x%08x, 1, &0x%08x)", pwszProgID, pIUnkOuter, dwCLSCTX, &ServerInfo, &MultiQI));
		XTEST(m_hWnd, hr = CoCreateInstanceEx(clsid, pIUnkOuter, dwCLSCTX, &ServerInfo, 1, &MultiQI));
		TESTC(m_pCListBox->OutputPostMethod(hr, "CoCreateInstanceEx(%S, 0x%08x, %d, &0x%08x, 1, &0x%08x)", pwszProgID, pIUnkOuter, dwCLSCTX, &ServerInfo, &MultiQI));
		
		//Output pointer from the MultiQI
		*ppIUnknown = MultiQI.pItf;
	}
	else
	{
		//CoCreateInstance
		TESTC(m_pCListBox->OutputPreMethod("CoCreateInstance(%S, 0x%08x, %d, %s, &0x%08x)", pwszProgID, pIUnkOuter, dwCLSCTX, GetInterfaceName(riid), ppIUnknown ? *ppIUnknown : NULL));
		XTEST(m_hWnd, hr = CoCreateInstance(clsid, pIUnkOuter, dwCLSCTX, riid, (void**)ppIUnknown));
		TESTC(m_pCListBox->OutputPostMethod(hr, "CoCreateInstance(%S, 0x%08x, %d, %s, &0x%08x)", pwszProgID, pIUnkOuter, dwCLSCTX, GetInterfaceName(riid), ppIUnknown ? *ppIUnknown : NULL));
	}

	
CLEANUP:
	SAFE_FREE(pwszProgID);
	return hr;
}


/////////////////////////////////////////////////////////////////////////////
// BOOL CEnum::IsConnectedToRootEnum
//
/////////////////////////////////////////////////////////////////////////////
BOOL CEnum::IsConnectedToRootEnum()
{
	return (BOOL)m_pIParseDisplayName;
}


/////////////////////////////////////////////////////////////////////////////
// HRESULT CEnum::ConnectToRootEnum
//
/////////////////////////////////////////////////////////////////////////////
HRESULT CEnum::ConnectToRootEnum()
{
	HRESULT hr = S_OK;

	//Initialize the OLE DB Enumerator and Obtain rowset
	//For some reason the RootEnum may fail, don't display error...
	TESTC(m_pCListBox->OutputPreMethod("CoCreateInstance(CLSID_OLEDB_ENUMERATOR, NULL, CLSCTX_INPROC_SERVER, IID_IParseDisplayName, &0x%08x)", m_pIParseDisplayName));
	hr = CoCreateInstance(CLSID_OLEDB_ENUMERATOR, NULL, CLSCTX_INPROC_SERVER, IID_IParseDisplayName, (void**)&m_pIParseDisplayName);
	TESTC(m_pCListBox->OutputPostMethod(hr, "CoCreateInstance(CLSID_OLEDB_ENUMERATOR, NULL, CLSCTX_INPROC_SERVER, IID_IParseDisplayName, &0x%08x)", m_pIParseDisplayName));

	//Now Delegate to our generic Enumerator method
	TESTC(hr = GetEnumRowset(m_pIParseDisplayName, &m_cEnumInfo, &m_rgEnumInfo));
	
	//NOTE:  The Root Enumerator doesn't include itself in the List of Enumerators
	//This is good for the case of tree controls would be never ending, but bad
	//for apps like this one, where you might want to see the "rowset" of the Root
	//Enum.  So to get arround this I will just add it to the list manually

	//Alloc room for extra MSDAENUM additon
	SAFE_REALLOC(m_rgEnumInfo, ENUMINFO, m_cEnumInfo + 1);
	wcscpy(m_rgEnumInfo[m_cEnumInfo].wszName,		L"MSDAENUM");
	wcscpy(m_rgEnumInfo[m_cEnumInfo].wszParseName,	L"{c8b522d0-5cf3-11ce-ade5-00aa0044773d}");
	wcscpy(m_rgEnumInfo[m_cEnumInfo].wszDescription,L"Microsoft OLE DB Root Enumerator");
	m_rgEnumInfo[m_cEnumInfo].wType					= DBSOURCETYPE_ENUMERATOR;
	m_rgEnumInfo[m_cEnumInfo].fIsParent				= VARIANT_TRUE;
	m_cEnumInfo++;


CLEANUP:
	return hr;
}



/////////////////////////////////////////////////////////////////////////////
// HRESULT CEnum::GetEnumRowset
//
/////////////////////////////////////////////////////////////////////////////
HRESULT CEnum::GetEnumRowset(IParseDisplayName* pIParseDisplayName, ULONG* pcEnumInfo, ENUMINFO** prgEnumInfo)
{
	HRESULT hr;
	ASSERT(pIParseDisplayName);
	ASSERT(pcEnumInfo);
	ASSERT(prgEnumInfo);

	HROW rghRows[MAX_BLOCK_SIZE];
	HROW* phRows = rghRows;
	ULONG cRowsObtained = 0;
	IRowset* pIRowset = NULL;

	IAccessor* pIAccessor = NULL;
	HACCESSOR hAccessor = DB_NULL_HACCESSOR;
	ULONG ulRefCount = 0;

	//Make our lives easier
	ULONG cEnumInfo = 0;
	ENUMINFO* rgEnumInfo = NULL;
	ISourcesRowset* pISourcesRowset = NULL;
	
	// Bind the user and table name for the list
	const static ULONG cBindings = 5;
	const static DBBINDING rgBindings[cBindings] = 
		{
			1,	 			
			offsetof(ENUMINFO, wszName),
			0,
			0,	
			NULL,			
			NULL, 		
			NULL,		
			DBPART_VALUE,
			DBMEMOWNER_CLIENTOWNED,		
			DBPARAMIO_NOTPARAM, 
			MAX_NAME_LEN, 		
			0, 				
			DBTYPE_WSTR, 	
			0,	
			0, 				

			2,	 			
			offsetof(ENUMINFO, wszParseName),
			0,
			0,	
			NULL,			
			NULL, 		
			NULL,		
			DBPART_VALUE,
			DBMEMOWNER_CLIENTOWNED,		
			DBPARAMIO_NOTPARAM, 
			MAX_NAME_LEN, 		
			0, 				
			DBTYPE_WSTR, 	
			0,	
			0, 				

			3,	 			
			offsetof(ENUMINFO, wszDescription),
			0,
			0,	
			NULL,			
			NULL, 		
			NULL,		
			DBPART_VALUE,
			DBMEMOWNER_CLIENTOWNED,		
			DBPARAMIO_NOTPARAM, 
			MAX_NAME_LEN, 		
			0, 				
			DBTYPE_WSTR, 	
			0,	
			0, 				
	
			4,	 			
			offsetof(ENUMINFO, wType),
			0,
			0,	
			NULL,			
			NULL, 		
			NULL,		
			DBPART_VALUE,
			DBMEMOWNER_CLIENTOWNED,		
			DBPARAMIO_NOTPARAM, 
			sizeof(DBTYPE), 		
			0, 				
			DBTYPE_UI2, 	
			0,	
			0, 				

			5,	 			
			offsetof(ENUMINFO, fIsParent),
			0,
			0,	
			NULL,			
			NULL, 		
			NULL,		
			DBPART_VALUE,
			DBMEMOWNER_CLIENTOWNED,		
			DBPARAMIO_NOTPARAM, 
			sizeof(VARIANT_BOOL), 
			0, 				
			DBTYPE_BOOL, 	
			0,	
			0, 				
	};

	//Obtain ISourcesRowset interface
	XTEST(m_hWnd, hr = m_pCListBox->OutputQI(pIParseDisplayName, IID_ISourcesRowset, (IUnknown**)&pISourcesRowset, "IParseDisplayName"));

	TESTC(m_pCListBox->OutputPreMethod("ISourcesRowset::GetSourcesRowset(NULL, IID_IRowset, 0, NULL, , &0x%08x)", pIRowset));
	XTEST(m_hWnd, hr = pISourcesRowset->GetSourcesRowset(NULL, IID_IRowset, 0, NULL, (IUnknown**)&pIRowset));
	TESTC(m_pCListBox->OutputPostMethod(hr, "ISourcesRowset::GetSourcesRowset(NULL, IID_IRowset, 0, NULL, , &0x%08x)", pIRowset));

	//Create Accessor
	XTEST(m_hWnd, hr = m_pCListBox->OutputQI(pIRowset, IID_IAccessor, (IUnknown**)&pIAccessor, "IRowset"));

	TESTC(m_pCListBox->OutputPreMethod("IAccessor::CreateAccessor(DBACCESSOR_ROWDATA, %d, 0x%08x, 0, &0x%08x, NULL)", cBindings, rgBindings, hAccessor));
	XTEST(m_hWnd, hr = pIAccessor->CreateAccessor(DBACCESSOR_ROWDATA, cBindings, rgBindings, 0, &hAccessor, NULL));
	TESTC(m_pCListBox->OutputPostMethod(hr, "IAccessor::CreateAccessor(DBACCESSOR_ROWDATA, %d, 0x%08x, 0, &0x%08x, NULL)", cBindings, rgBindings, hAccessor));

	//Loop through the entire returned rowet
	while(TRUE)
	{
		TESTC(m_pCListBox->OutputPreMethod("IRowset::GetNextRows(NULL, 0, %d, &%d, &0x%08x)", MAX_BLOCK_SIZE, cRowsObtained, phRows));
		XTEST(m_hWnd, hr = pIRowset->GetNextRows(NULL, 0, MAX_BLOCK_SIZE, &cRowsObtained, &phRows));
		TESTC(m_pCListBox->OutputPostMethod(hr, "IRowset::GetNextRows(NULL, 0, %d, &%d, &0x%08x)", MAX_BLOCK_SIZE, cRowsObtained, phRows));
		
		//ENDOFROWSET
		if(cRowsObtained==0) 
			break;
		
		//Alloc room for ProviderInfo (in chunks)
		SAFE_REALLOC(rgEnumInfo, ENUMINFO, cEnumInfo + cRowsObtained);
		memset(&rgEnumInfo[cEnumInfo], 0, sizeof(ENUMINFO)*cRowsObtained);

		//Loop over rows obtained and get ProviderInfo
		for(ULONG i=0; i<cRowsObtained; i++) 
		{	
			//Get the Data
			TESTC(m_pCListBox->OutputPreMethod("IRowset::GetData(0x%08x, 0x%08x, 0x%08x)", rghRows[i], hAccessor, &rgEnumInfo[cEnumInfo]));
			XTEST(m_hWnd, hr = pIRowset->GetData(rghRows[i], hAccessor, (void*)&rgEnumInfo[cEnumInfo]));
			TESTC(m_pCListBox->OutputPostMethod(hr, "IRowset::GetData(0x%08x, 0x%08x, 0x%08x)", rghRows[i], hAccessor, &rgEnumInfo[cEnumInfo]));
			cEnumInfo++;
		}
			
		//Release all the rows
		TESTC(m_pCListBox->OutputPreMethod("IRowset::ReleaseRows(%d, 0x%08x, NULL, NULL, NULL)", cRowsObtained, rghRows));
		XTEST(m_hWnd, hr = pIRowset->ReleaseRows(cRowsObtained, rghRows, NULL, NULL, NULL));
		TESTC(m_pCListBox->OutputPostMethod(hr, "IRowset::ReleaseRows(%d, 0x%08x, NULL, NULL, NULL)", cRowsObtained, rghRows));
	}

CLEANUP:
	//Output Params
	*pcEnumInfo = cEnumInfo;
	*prgEnumInfo = rgEnumInfo;
	
	if(hAccessor && pIAccessor)
	{
		HRESULT hrOptional = S_OK;
		m_pCListBox->OutputPreMethod("IAccessor::ReleaseAccessor(0x%08x, &%d)", hAccessor, ulRefCount);
		XTEST(m_hWnd, hrOptional = pIAccessor->ReleaseAccessor(hAccessor, &ulRefCount));
		m_pCListBox->OutputPostMethod(hrOptional, "IAccessor::ReleaseAccessor(0x%08x, &%d)", hAccessor, ulRefCount);
	}

	m_pCListBox->OutputRelease((IUnknown**)&pISourcesRowset,	"ISourcesRowset");
	m_pCListBox->OutputRelease((IUnknown**)&pIRowset,			"IRowset");
	m_pCListBox->OutputRelease((IUnknown**)&pIAccessor,			"IAccessor");
	return hr;
}


